/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.evil;

import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.content.entity.EvilSpirit;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPEntities;
import dev.xkmc.curseofpandora.init.registrate.CoPItems;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class EvilSpiritEvoke
extends ITokenProviderItem<Data> {
    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.evil.evilSpiritEvokeRealityIndex.get();
    }

    private static int getLife() {
        return (Integer)CoPConfig.COMMON.evil.evilSpiritEvokeDuration.get();
    }

    private static int getCD() {
        return (Integer)CoPConfig.COMMON.evil.evilSpiritEvokeCoolDown.get();
    }

    public EvilSpiritEvoke(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= EvilSpiritEvoke.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(EvilSpiritEvoke.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Evil.EVOKE.get((int)Math.round((double)EvilSpiritEvoke.getLife() / 20.0), (int)Math.round((double)EvilSpiritEvoke.getCD() / 20.0))).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Evil.EVOKE_CONVERT.get(new Object[0])).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)EvilSpiritEvoke.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        @Override
        protected void removeImpl(Player player) {
        }

        @Override
        protected void tickImpl(Player player) {
        }

        @Override
        public void onPlayerAttacked(Player player, AttackCache cache) {
            LivingEntity livingEntity = cache.getAttacker();
            if (livingEntity instanceof Vex) {
                Vex vex = (Vex)livingEntity;
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    cache.getLivingAttackEvent().setCanceled(true);
                    ServerLevel sl = sp.m_284548_();
                    EvilSpirit spirit = (EvilSpirit)vex.m_21406_((EntityType)CoPEntities.EVIL_SPIRIT.get(), false);
                    if (spirit == null) {
                        return;
                    }
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        ItemStack stack = vex.m_6844_(slot);
                        if (stack.m_41619_()) continue;
                        spirit.m_8061_(slot, stack);
                    }
                    spirit.m_6518_((ServerLevelAccessor)sl, sl.m_6436_(spirit.m_20183_()), MobSpawnType.CONVERSION, null, null);
                    spirit.setLimitedLife(EvilSpiritEvoke.getLife());
                    spirit.setOwner(player);
                    if (spirit.m_21205_().m_41619_()) {
                        spirit.m_21008_(InteractionHand.MAIN_HAND, Items.f_42383_.m_7968_());
                    }
                    if (vex.m_19749_() != null) {
                        spirit.m_6710_((LivingEntity)vex.m_19749_());
                    }
                    ForgeEventFactory.onLivingConvert((LivingEntity)vex, (LivingEntity)spirit);
                }
            }
        }

        @Override
        public void onPlayerDamaged(Player player, AttackCache cache) {
            EvilSpiritEvoke item = (EvilSpiritEvoke)((Object)CoPItems.EVIL_SPIRIT_EVOKE.get());
            if (cache.getAttacker() != null && !player.m_36335_().m_41519_((Item)item)) {
                player.m_36335_().m_41524_((Item)item, EvilSpiritEvoke.getCD());
                EvilSpirit vex = new EvilSpirit(player);
                vex.setOwner(player);
                vex.setLimitedLife(EvilSpiritEvoke.getLife());
                vex.m_21008_(InteractionHand.MAIN_HAND, Items.f_42383_.m_7968_());
                vex.m_6710_(cache.getAttacker());
                player.m_9236_().m_7967_((Entity)vex);
            }
        }
    }
}

